<?php
namespace lib;

class Image
{
	private $handle;
	
	public function __construct($url, $type=false)
	{
		if(!$type)
		{
			$info = @getimagesize($url);
			
			$type = $info[2];
		}
		
		$functions = array
		(
			'image/gif'		=> 'imagecreatefromgif',
			'image/jpeg'	=> 'imagecreatefromjpeg',
			'image/png'		=> 'imagecreatefrompng',
			'image/wbmp'	=> 'imagecreatefromwbmp',
			'image/xbm'		=> 'imagecreatefromwxbm'
        );
		
		if(isset($functions[$type]) && function_exists($functions[$type]))
		{
			$this->handle = $functions[$type]($url);
		}
	}
	
	public function width()
	{
		return imagesx($this->handle);
	}
	
	public function height()
	{
		return imagesy($this->handle);
	}
	
	public function resize($width, $height)
	{
		$tmp = imagecreatetruecolor($width, $height);
		
		if($this->width()*$height/$this->height() < $width)
		{
			$crop_width = $this->width();
			$crop_height = $height*$crop_width/$width;
			
			$x = 0;
			$y = ($this->height() - $crop_height)/2;
		} else
		{
			$crop_height = $this->height();
			$crop_width = $width*$crop_height/$height;
			
			$x = ($this->width() - $crop_width)/2;
			$y = 0;
		}
		
		imagecopyresampled($tmp, $this->handle, 0, 0, $x, $y, $width, $height, $crop_width, $crop_height);
		
		$this->handle = $tmp;
	}
	
	public function save($path)
	{
		$functions = array
		(
			'.png'	=>	'imagepng',
			'.jpg'	=>	'imagejpeg',
			'.gif'	=>	'imagegif'
		);
		
		$extension = substr($path, -4);
		
		if(isset($functions[$extension]) && function_exists($functions[$extension]))
		{
			return $functions[$extension]($this->handle, $path);
		}
		
		return false;
	}
	
	public function validate($validation)
	{
		foreach($validation as $key=>$value)
		{
			switch($key)
			{
				case 'image_size':
					$this->resize($value[0], $value[1]);
				break;
			}
		}
	}
}